#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "libfma.h"
#include "lf_fabric.h"

#include "linktest.h"
#include "gmstuff.h"



static int Hport;               /* Host port ID to test links from */

char *One_switch;
extern int Test_kbytes;
extern double BWthresh;
extern int My_host_id;
char *Test_x1;
int Test_p1;
char *Test_x2;
int Test_p2;
char __b1[100], __b2[100];
int Show_route;

void
parse_args(
  int argc,
  char **argv)
{
  int c;
  extern char *optarg;

  Hport = -1;			/* -1 means all */
  Test_kbytes = 4096;
  BWthresh = 100.;
  Test_x1 = NULL;
  One_switch = NULL;

  while ((c = getopt(argc, argv, "S:ri:l:t:")) != EOF) switch (c) {
  case 'S':
    One_switch = optarg;
    break;

  case 'r':
    Show_route = 1;
    break;

  case 'i':  /* Host port Id to test out of */
    Hport = atoi(optarg);
    break;

  case 'l':
    Test_kbytes = atoi(optarg);
    break;

  case 't':
    BWthresh = atoi(optarg);
    break;

  case 'T':
    {
      char *pp;

      Test_x1 = __b1;
      Test_x2 = __b2;
      pp = index(optarg,':');
      assert(pp != NULL);
      *pp = 0;
      strcpy(Test_x1, optarg);
      Test_p1 = atoi(pp+1);
      pp = index(pp+1, '/');
      assert(pp != NULL);
      optarg = pp+1;

      pp = index(optarg,':');
      assert(pp != NULL);
      *pp = 0;
      strcpy(Test_x2, optarg);
      Test_p2 = atoi(pp+1);
    }
    printf("Testing %s:%d <-> %s:%d\n", Test_x1, Test_p1, Test_x2, Test_p2);
    break;

  }
}

struct lf_host *
find_self(
  struct lf_fabric *fp)
{
  char hostname[128];
  struct lf_host *hp;
  int rc;

  rc = gethostname(hostname, sizeof(hostname));
  if (rc == -1) LF_ERROR(("gethostname"));

  hp = lf_find_host_by_name(fp, hostname);
  if (hp == NULL) LF_ERROR(("Cannot find self in database"));

  return hp;

 except:
  exit(1);
}


int
main(
  int argc,
  char **argv)
{
  struct lf_fabric *fp;
  struct lf_host *myhp;
  struct lf_nic *nicp;
  int ifc;


  parse_args(argc, argv);


  initialize_gm();   

  fp = lf_simple_load_fabric();
  if (fp == NULL) {
    fprintf(stderr, "Error loading fabric\n");
    exit(1);
  }

  myhp = find_self(fp);
  nicp = myhp->nics[0];

  /* If user asked to test out of a single port instead of all ports,
   * make sure that port exists according to the map.
   */
  if (Hport != -1) {
    if (Hport >= nicp->num_ports) {
      fprintf(stderr, "Requested host interface number too big\n");
      exit(1);
    }
  }

  // calc_xbar_routes(fp, nicp);  /* calculate routes to all xbars */ 

  if (Hport == -1) {
    for (ifc = 0; ifc < nicp->num_ports; ifc++) {
      check_all_links(fp, nicp, ifc);
    }
  } else {
    /* Just do checking out of whatever port Hport is set to */
    check_all_links(fp, nicp, Hport);
  }

  close_gm();

  return 0;
}   
